package doABC.Cpool;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class NamespaceInfo extends SwfTools{

	private int id;
	private CpoolInfo cpool;
	public static HashMap<Integer, String> namespaceKind = new HashMap<Integer, String>();
	
	public HashMap<Integer, String> getNamespaceKind() {
		return namespaceKind;
	}

	private int start=-1;
	private int end=-1;
	//struktury
	private int kind;//u8
	private int name;
	
	

	public  NamespaceInfo(CpoolInfo cpool, String kind, int name, int id){
		super();
		this.cpool = cpool;
		this.kind = getFlags(kind);
		this.name = name;
		initNamespaceKind();
		this.id = id;
	}
	
	public  NamespaceInfo(CpoolInfo cpool, int kind, int name, int id){
		super();
		this.cpool = cpool;
		this.kind = kind;
		this.name = name;
		initNamespaceKind();
		this.id = id;
	}
	
	public int getId() {
		return id;
	}


	public void setKind(String kind) {
		this.kind = getFlags(kind);
	}

	public void setName(int name) {
		this.name = name;
	}

	public  NamespaceInfo( ByteBuffer bbuf, CpoolInfo cpool){
		super();
		this.cpool = cpool;
		namespace_info(bbuf);
		initNamespaceKind();
	}
	
	
	private void namespace_info(ByteBuffer bbuf){
		start = bbuf.position();
		
		kind =unsignedByte(bbuf.get());
		name = unsigned30int(bbuf);

		end = bbuf.position()-1;
	}
	
	//getters

	public String getName_string() {
		//if (kind==0x05) return "private";
		return cpool.getStrings().get(name).getUtf8_string();
		
	}
	
	public int getFlags(String flags) {
		return (Integer)getKeyFromValue(namespaceKind, flags);
	}

	public int getKind() {
		return kind;
	}
	
	public String getKind_string() {
		return namespaceKind.get(kind);
	}


	public int getName() {
		return name;
	}

	
	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}


	public String String(){
		String wynik ="";
		wynik+="\n---#--- ns_set_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "kind: " + kind+"\n";
			
		wynik+= "name: " + getName_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+=getName_string();
		return wynik;
	}
	
	public static HashMap<Integer, String> initNamespaceKind() {
		namespaceKind.put(0x08,"CONSTANT_Namespace");
		namespaceKind.put(0x05,"private");
		namespaceKind.put(0x16,"CONSTANT_PackageNamespace" );
		namespaceKind.put(0x17,"CONSTANT_PackageInternalNs" );
		namespaceKind.put(0x18,"CONSTANT_ProtectedNamespace" );
		namespaceKind.put(0x19,"CONSTANT_ExplicitNamespace" );
		namespaceKind.put(0x1A,"CONSTANT_StaticProtectedNs" );
		namespaceKind.put(0x05,"CONSTANT_PrivateNs" );
		return namespaceKind;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			result.add((byte)kind);

			for (byte b :getUI32(name))
					result.add(b);

		return result;
	}
	
}
